using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using System.Data.SqlClient;
using System.DirectoryServices;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;
using System.Text.RegularExpressions;
using AntiXssEnc = Microsoft.Security.Application;

namespace VIRP.CRS.DAL
{
	public partial class USERSDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public USERSDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public USERS GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 USER_ID)
        {
            USERS objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_USERS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, USER_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<USERS> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<USERS> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_USERS_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, USERS objSave)
        {
            Int32? objReturn = objSave.USER_ID;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_USERS_save(CURRENT_USER,
                        CURRENT_REGISTRY_ID,
                        objSave.ACCOUNT_EXPIRE_DATE,
                        objSave.ACCOUNT_LOCK_DATE,
                        objSave.AGREEMENT_SIGNATURE_CODE,
                        DateTime.Now,
                        objSave.CREATEDBY,
                        objSave.DEFAULT_REGISTRY_ID,
                        objSave.Domain,
                        objSave.EMAIL_ADDRESS,
                        objSave.EMPLOYEE_NUMBER,
                        objSave.FAX_NUMBER,
                        objSave.FIRST_NAME,
                        objSave.FULL_NAME,
                        objSave.INACTIVE_DATE,
                        objSave.INACTIVE_FLAG,
                        objSave.INITIAL_LOGIN_DATE,
                        objSave.JOB_TITLE,
                        objSave.LAST_NAME,
                        objSave.MAIDEN_NAME,
                        objSave.MIDDLE_NAME,
                        objSave.NUMBER_OF_LOGIN_ATTEMPTS,
                        objSave.PWD,
                        objSave.PASSWORD_CHANGE_DATE,
                        objSave.PASSWORD_CREATE_DATE,
                        objSave.PASSWORD_EXPIRE_DATE,
                        objSave.SIGNATURE_VERIFIED_IND,
                        objSave.TELEPHONE_NUMBER,
                        DateTime.Now,
                        objSave.UPDATEDBY,
                        ref objReturn,
                        objSave.USERNAME,
                        objSave.RECEIVE_EMAIL);

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }

        public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 USER_ID)
        {
            Boolean objReturn = false;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_USERS_delete(CURRENT_USER, CURRENT_REGISTRY_ID, USER_ID);
                    objReturn = true;
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public USERS ParseReaderCustom(DataRow row)
        {
            USERS objReturn = new USERS
            {
                ACCOUNT_EXPIRE_DATE = row.Field<DateTime?>("USERS_ACCOUNT_EXPIRE_DATE"),
                ACCOUNT_LOCK_DATE = row.Field<DateTime?>("USERS_ACCOUNT_LOCK_DATE"),
                AGREEMENT_SIGNATURE_CODE = row.Field<string>("USERS_AGREEMENT_SIGNATURE_CODE"),
                CREATED = row.Field<DateTime>("USERS_CREATED"),
                CREATEDBY = row.Field<string>("USERS_CREATEDBY"),
                DEFAULT_REGISTRY_ID = row.Field<int?>("USERS_DEFAULT_REGISTRY_ID"),
                Domain = row.Field<string>("USERS_Domain"),
                EMAIL_ADDRESS = row.Field<string>("USERS_EMAIL_ADDRESS"),
                EMPLOYEE_NUMBER = row.Field<string>("USERS_EMPLOYEE_NUMBER"),
                FAX_NUMBER = row.Field<string>("USERS_FAX_NUMBER"),
                FIRST_NAME = row.Field<string>("USERS_FIRST_NAME"),
                FULL_NAME = row.Field<string>("USERS_FULL_NAME"),
                INACTIVE_DATE = row.Field<DateTime?>("USERS_INACTIVE_DATE"),
                INACTIVE_FLAG = row.Field<bool>("USERS_INACTIVE_FLAG"),
                INITIAL_LOGIN_DATE = row.Field<DateTime?>("USERS_INITIAL_LOGIN_DATE"),
                JOB_TITLE = row.Field<string>("USERS_JOB_TITLE"),
                LAST_NAME = row.Field<string>("USERS_LAST_NAME"),
                MAIDEN_NAME = row.Field<string>("USERS_MAIDEN_NAME"),
                MIDDLE_NAME = row.Field<string>("USERS_MIDDLE_NAME"),
                NUMBER_OF_LOGIN_ATTEMPTS = row.Field<int?>("USERS_NUMBER_OF_LOGIN_ATTEMPTS"),
                PWD = row.Field<string>("USERS_PASSWORD"),
                PASSWORD_CHANGE_DATE = row.Field<DateTime?>("USERS_PASSWORD_CHANGE_DATE"),
                PASSWORD_CREATE_DATE = row.Field<DateTime?>("USERS_PASSWORD_CREATE_DATE"),
                PASSWORD_EXPIRE_DATE = row.Field<DateTime?>("USERS_PASSWORD_EXPIRE_DATE"),
                SIGNATURE_VERIFIED_IND = row.Field<string>("USERS_SIGNATURE_VERIFIED_IND"),
                TELEPHONE_NUMBER = row.Field<string>("USERS_TELEPHONE_NUMBER"),
                UPDATED = row.Field<DateTime>("USERS_UPDATED"),
                UPDATEDBY = row.Field<string>("USERS_UPDATEDBY"),
                USER_ID = row.Field<int>("USERS_USER_ID"),
                USERNAME = row.Field<string>("USERS_USERNAME"),
                RECEIVE_EMAIL = row.Field<bool?>("USERS_RECEIVE_EMAIL")
            };

            return objReturn;
        }

        public List<DomainUser> GetActiveDirectory(DomainNames domainNames, string searchString)
        {
            List<DomainUser> objReturn = null;
            bool isValidSearch = false;

            try
            {
                using (DirectoryEntry rootEntry = new DirectoryEntry("GC://DC=va,DC=gov"))
                {
                    using (DirectorySearcher searcher = new DirectorySearcher(rootEntry))
                    {
                        searcher.PropertiesToLoad.Add("distinguishedName");
                        searcher.PropertiesToLoad.Add("sAMAccountName");
                        searcher.PropertiesToLoad.Add("givenName");
                        //searcher.PropertiesToLoad.Add("middleName");//Property doesn't exist
                        searcher.PropertiesToLoad.Add("sn");
                        //searcher.PropertiesToLoad.Add("maidenName");//Property doesn't exist
                        searcher.PropertiesToLoad.Add("mail");
                        //searcher.PropertiesToLoad.Add("employeeNumber");//Property doesn't exist
                        searcher.PropertiesToLoad.Add("title");
                        searcher.PropertiesToLoad.Add("telephoneNumber");
                        searcher.PropertiesToLoad.Add("facsimileTelephoneNumber");

                        //searcher.ServerTimeLimit = new TimeSpan(0, 0, 30);
                        //searcher.ClientTimeout = new TimeSpan(0, 10, 0);

                        //Validate searchString (LDAP Injection )

                        string whitelist = "^[a-zA-Z0-9-,. ]+$";
                        Regex pattern = new Regex(whitelist);

                        if (!pattern.IsMatch(searchString))
                        {
                            isValidSearch = false;
                        }
                        else
                        {
                            isValidSearch = true;

                            //Filter results by last name and/or first name and must have username
                            searcher.Filter = "(&(anr=" + searchString + ")(sAMAccountName=*)(objectCategory=person))";

                            LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                            using (SearchResultCollection queryResults = searcher.FindAll())
                            {
                                LogManager.LogTiming(logDetails);

                                //If there is a better way to bind AD Results to a Grid 
                                //we should implement it.  This loop seems to take up a 
                                //majority of the time in this process.
                                if (queryResults != null && queryResults.Count > 0)
                                {
                                    objReturn = new List<DomainUser>();

                                    foreach (SearchResult searchResult in queryResults)
                                    {
                                        string username = string.Empty;
                                        string domainName = string.Empty;
                                        string accountName = string.Empty;

                                        if (searchResult.Properties.Contains("distinguishedName"))
                                        {
                                            domainName = domainNames.FindByDistinguishedName(searchResult.Properties["distinguishedName"][0].ToString());
                                        }

                                        if (searchResult.Properties.Contains("sAMAccountName"))
                                        {
                                            accountName = searchResult.Properties["sAMAccountName"][0].ToString().ToUpper();
                                        }

                                        username = domainName + "\\" + accountName;

                                        DomainUser user = new DomainUser(searchResult);
                                        user.Username = AntiXssEnc.Encoder.HtmlEncode(username);
                                        objReturn.Add(user);
                                    }
                                }
                            }
                        }
                    }
                }

                if (!isValidSearch)
                    throw new Exception("Invalid Search Criteria");
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn;
        }
        
        public USERS GetItemByName(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string username)
        {
            USERS objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_USERS_getitemByName(CURRENT_USER, CURRENT_REGISTRY_ID, username).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<USERS> GetItemsByUser(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<USERS> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_USERS_getitemsByUser(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<USERS> GetSystemUsers(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<USERS> objReturn = null;

            SqlConnection sConn = null;
            SqlCommand sCmd = null;
            SqlDataAdapter sAdapter = null;
            DataSet objTemp = null;

            try
            {
                sConn = new SqlConnection(SqlConnectionString);

                sConn.Open();

                sCmd = new SqlCommand("CRS.usp_USERS_getitemsSystemUsers", sConn);
                sCmd.CommandTimeout = SqlCommandTimeout;
                sCmd.CommandType = CommandType.StoredProcedure;
                sCmd.Parameters.AddWithValue("@CURRENT_USER", CURRENT_USER);
                sCmd.Parameters.AddWithValue("@CURRENT_REGISTRY_ID", CURRENT_REGISTRY_ID);

                objTemp = new DataSet();
                sAdapter = new SqlDataAdapter(sCmd);

                LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                sAdapter.Fill(objTemp);
                LogManager.LogTiming(logDetails);
                CheckDataSet(objTemp);

                if (objTemp != null && objTemp.Tables.Count > 0 && objTemp.Tables[0].Rows.Count > 0)
                {
                    var myData = objTemp.Tables[0].AsEnumerable().Select(r => ParseReaderComplete(r));
                    if (myData != null)
                    {
                        objReturn = myData.ToList<USERS>();
                    }
                }

                sConn.Close();
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }
            finally
            {
                if (sAdapter != null)
                {
                    sAdapter.Dispose();
                    sAdapter = null;
                }
                if (sCmd != null)
                {
                    sCmd.Dispose();
                    sCmd = null;
                }
                if (sConn != null)
                {
                    if (sConn.State != ConnectionState.Closed) { sConn.Close(); }
                    sConn.Dispose();
                    sConn = null;
                }
            }

            return objReturn;
        }

        public Boolean SetDefaultRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Boolean IS_DEFAULT)
        {
            Boolean objReturn = false;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_USERS_setDefaultRegistry(CURRENT_USER, CURRENT_REGISTRY_ID, IS_DEFAULT);
                    objReturn = true;
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public USERS ParseReaderComplete(DataRow row)
        {
            USERS user = ParseReaderCustom(row);
            if (user != null)
            {
                USER_ROLESDB uSER_ROLESDB = new USER_ROLESDB();
                USER_ROLES userRole = uSER_ROLESDB.ParseReaderCustom(row);
                if (userRole != null)
                {
                    STD_ROLEDB sTD_ROLEDB = new STD_ROLEDB();
                    userRole.STD_ROLE = sTD_ROLEDB.ParseReaderCustom(row);
                }
                user.USER_ROLES = new List<USER_ROLES>();
                user.USER_ROLES.Add(userRole);
            }

            return user;
        }

		#endregion
	}
}
